<?php
function setup_controller_network( $argv ) {
    global $DTASCFG_XML_FILE, $BACKEND ;

    try {
        if( count( $argv ) < 2 ) {
            echo "Usage: " . basename( __FILE__, ".inc" ) . " <SC_INDEX> <DHCP> <IP> <MASK> <GATEWAY> <DNS>\n" ;
            exit( 1 ) ;
        }

        $idx          = $argv[ 0 ] ;
        $dhcp_enabled = $argv[ 1 ] ;
        if( ! $dhcp_enabled ) {
            if( count( $argv ) != 6 ) {
                echo "Usage: " . basename( __FILE__, ".inc" ) . "<SC_INDEX> <DHCP> <IP> <MASK> <GATEWAY> <DNS>\n" ;
                exit( 1 ) ;
            }
        }

        $ip      = $dhcp_enabled ? "" : $argv[ 2 ] ;
        $mask    = $dhcp_enabled ? "" : $argv[ 3 ] ;
        $gateway = $dhcp_enabled ? "" : $argv[ 4 ] ;
        $dns     = $dhcp_enabled ? "" : $argv[ 5 ] ;

        $xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
        
        $esxi_ip           = chop( $xml -> esxi -> ip ) ;
        $esxi_username     = chop( $xml -> esxi -> username ) ;
        $esxi_password     =       $xml -> esxi -> password ;
        $sc_prefix         = chop( $xml -> sandbox_controller -> prefix ) ;
        $sc_admin_username = chop( $xml -> sandbox_controller -> admin_username ) ;
        $sc_admin_password =       $xml -> sandbox_controller -> admin_password ;
        $sc_vmpath         = chop( $xml -> sandbox_controller -> image_path ) ;
        $sc_vmpath_vix     = chop( $xml -> sandbox_controller -> image_path_vix ) ;

        
        # ensure that var '$sc_vmpath_vix' is not NULL
        debug_print( "EnsureScVmPathNotEmpty: sc_vmpath_vix='$sc_vmpath_vix'" ) ;
        if( $sc_vmpath_vix == "" ) {
            debug_print( "ScVmPathEmpty: QueryFromEsxi" ) ;
            $sc_prefix = isset( $argv[ 'sc_prefix' ] ) ? $argv[ 'sc_prefix' ] : trim( $xml -> sandbox_controller -> prefix ) ;
            $sc_vmpath_vix = get_vm_vixpath(
                $esxi_ip,
                $esxi_username,
                $esxi_password,
                $sc_prefix ) ;
            debug_print( "EnsureScVmPathNotEmpty: sc_vmpath_vix='$sc_vmpath_vix'" ) ;
        }
        
        # ensure that SC is up and ready
        debug_print( "EnsureSandboxControllerIsPowerOn" ) ;
        start_vm_and_wait( $esxi_ip, $esxi_username, $esxi_password, $sc_vmpath ) ;
        debug_print( "SandboxControllerIsPowerOn" ) ;
        
        $retryCount    = 0 ;
        $retryCountMax = 30 ;
        $retryInterval = 30 ;
        while( true ) {
        
            debug_print( "QueryVmwareToolsStatusAtSc" ) ;
            $ret_array = run_program_at_ms( array(
                'exit_when_error' => 0,
                'program'         => "vmware-cmd",
                'arguments'       => array(
                    "-H", $esxi_ip,
                    "-U", $esxi_username,
                    "-P", $esxi_password,
                    $sc_vmpath,
                    "gettoolslastactive"
            ) ) ) ;
            $retCode = $ret_array[ 0 ] ;
            $msg     = join( "\n", $ret_array[ 1 ] ) ;
            if( $retCode != 0 ) {
                throw new Exception( "QueryVmwareToolsStatusAtScFail: ret='$retCode', msg='$msg'" ) ;
            }
            debug_print( "QueryVmwareToolsStatusAtScSuccess: msg='$msg'" ) ;

            # display message according to different vmware-cmd return codes
            if( strcasecmp( $msg, "gettoolslastactive() = 1" ) === 0 ) {
                debug_print( "Guest operating system is responding normally." ) ;
                break ;
            }
            elseif( strcasecmp( $msg, "gettoolslastactive() = 0" ) === 0 ) {
                debug_print( "VMware Tools is not installed or not running." ) ;
            }
            elseif( strcasecmp( $msg, "gettoolslastactive() = 5" ) === 0 ) {
                debug_print( "Intermittent heartbeat. There might be a problem with the guest operating system." ) ;
            }
            elseif( strcasecmp( $msg, "gettoolslastactive() = 100" ) === 0 ) {
                debug_print( "No heartbeat. Guest operating system might have stopped responding." ) ;
            }
            else {
                # throw new Exception( "UnrecognizedVmwareReturnCode: msg='$msg'" ) ;
                debug_print( "UnrecognizedVmwareReturnCode: msg='$msg'" ) ;
            }
            
            debug_print( "SandboxController is not ready." ) ;
            debug_print( "Sleep $retryInterval seconds..." ) ;
            sleep( $retryInterval ) ;
            
            $retryCount++ ;
            if( $retryCount > $retryCountMax ) {
                throw new Exception( "WaitForSandboxControllerToReadyTimeout" ) ;
            }
            
            debug_print( "retry($retryCount/$retryCountMax)..." ) ;
        }
        debug_print( "SandboxController is ready." ) ;
        
        # copy files from MS to SC
        $from = dirname(__FILE__) . "/network_config.php" ;
        $to   = "/tmp/network_config.php" ;
        debug_print( "CopyFileToSc: from='$from', to='$to'" ) ;
        $ret_array = copy_file_to_sc( array(
            'exit_when_error' => 0,
            'sc_vmpath_vix'   => $sc_vmpath_vix,
            'from'            => $from,
            'to'              => $to
        ) ) ;
        $retCode = $ret_array[ 0 ] ;
        $msg     = join( "\n", $ret_array[ 1 ] ) ;
        if( $retCode != 0 ) {
            throw new Exception( "CopyFileToScFail: ret='$retCode', msg='$msg', from='$from', to='$to'" ) ;
        }
        debug_print( "CopyFileToScSuccess: msg='$msg'" ) ;

        
        $retryCount    = 0 ;
        $retryCountMax = 30 ;
        $retryInterval = 30 ;
        $program = "/tmp/network_config.php" ;
        while( true ) {
        
            # launch program to get SC's ip
            debug_print( "RunProgramAtSc: program='$program'" ) ;
            $ret_array = run_program_at_sc( array(
                'exit_when_error' => 0,
                'sc_vmpath_vix'   => $sc_vmpath_vix,
                'program'         => $program,
                'pipe_to'         => "/tmp/network-info",
                'arguments'       => array(
                    $dhcp_enabled,
                    $ip,
                    $mask,
                    $gateway,
                    $dns
            ) ) ) ;
            $retCode = $ret_array[ 0 ] ;
            $msg     = join( "\n", $ret_array[ 1 ] ) ;
            if( $retCode != 0 ) {
                $tmpMsg = "RunProgramAtScFail: ret='$retCode', msg='$msg', program='$program'" ;
                
                $retryCount++ ;
                if( $retryCount > $retryCountMax ) {
                    throw new Exception( $tmpMsg ) ;
                }
                debug_print( $tmpMsg ) ;
                
                debug_print( "Sleep $retryInterval seconds..." ) ;
                sleep( $retryInterval ) ;
                
                debug_print( "retry($retryCount/$retryCountMax)..." ) ;
                continue ;
            }
            debug_print( "RunProgramAtScSuccess: msg='$msg'" ) ;
            
            
            # copy file from SC
            $from = "/tmp/network-info" ;
            $to   = dirname(__FILE__) . "/ctrl-network-info" ;
            debug_print( "CopyFileFromSc: from='$from', to='$to'" ) ;
            $ret_array = copy_file_from_sc( array(
                'exit_when_error' => 0,
                'sc_vmpath_vix'   => $sc_vmpath_vix,
                'from'            => $from,
                'to'              => $to
            ) ) ;
            $retCode = $ret_array[ 0 ] ;
            $msg     = join( "\n", $ret_array[ 1 ] ) ;
            if( $retCode != 0 ) {
                $tmpMsg = "CopyFileFromScFail: ret='$retCode', msg='$msg', from='$from', to='$to'" ;
                
                $retryCount++ ;
                if( $retryCount > $retryCountMax ) {
                    throw new Exception( $tmpMsg ) ;
                }
                debug_print( $tmpMsg ) ;
                
                debug_print( "Sleep $retryInterval seconds..." ) ;
                sleep( $retryInterval ) ;
                
                debug_print( "retry($retryCount/$retryCountMax)..." ) ;
                continue ;
            }
            debug_print( "CopyFileFromScSuccess: msg='$msg'" ) ;
            
            
            # delete file at SC
            $file = "/tmp/network-info" ;
            debug_print( "DeleteFileAtSc: file='$file'" ) ;
            $ret_array = run_program_at_sc( array(
                'exit_when_error' => 0,
                'sc_vmpath_vix'   => $sc_vmpath_vix,
                'program'         => "/bin/rm",
                'arguments'       => array( $file )
            ) ) ;
            $retCode = $ret_array[ 0 ] ;
            $msg     = join( "\n", $ret_array[ 1 ] ) ;
            if( $retCode != 0 ) {
                $tmpMsg = "DeleteFileAtScFail: ret='$retCode', msg='$msg', file='$file'" ;
                
                $retryCount++ ;
                if( $retryCount > $retryCountMax ) {
                    throw new Exception( $tmpMsg ) ;
                }
                debug_print( $tmpMsg ) ;
                
                debug_print( "Sleep $retryInterval seconds..." ) ;
                sleep( $retryInterval ) ;
                
                debug_print( "retry($retryCount/$retryCountMax)..." ) ;
                continue ;
            }
            debug_print( "DeleteFileAtScSuccess: msg='$msg'" ) ;
            
            
            # extract sandbox controller's network info
            $resultFile = dirname(__FILE__) . "/ctrl-network-info" ;
            if( file_exists( $resultFile ) == false ) {
                $tmpMsg = "FileNotExist: File='$resultFile'" ;
                
                $retryCount++ ;
                if( $retryCount > $retryCountMax ) {
                    throw new Exception( $tmpMsg ) ;
                }
                debug_print( $tmpMsg ) ;
                
                debug_print( "Sleep $retryInterval seconds..." ) ;
                sleep( $retryInterval ) ;
                
                debug_print( "retry($retryCount/$retryCountMax)..." ) ;
                continue ;
            }
            
            $lines = file( $resultFile ) ;
            $msg = join( " ", $lines ) ;
            
            $items = preg_split( "/\s+/", $msg ) ;
            $ip      = array_key_exists( 0, $items ) ? $items[ 0 ] : "" ;
            $mask    = array_key_exists( 1, $items ) ? $items[ 1 ] : "" ;
            $gateway = array_key_exists( 2, $items ) ? $items[ 2 ] : "" ;
            $dns     = array_key_exists( 3, $items ) ? $items[ 3 ] : "" ;

            unlink( $resultFile ) ;

            if( $ip == "" || $mask == "" || $gateway == "" || $dns == "" ) {
                $tmpMsg = "ConfigureSandboxControllerNetworkFail: ip='$ip', mask='$mask', gateway='$gateway', dns='$dns'" ;
                
                $retryCount++ ;
                if( $retryCount > $retryCountMax ) {
                    throw new Exception( $tmpMsg ) ;
                }
                debug_print( $tmpMsg ) ;
                
                debug_print( "Sleep $retryInterval seconds..." ) ;
                sleep( $retryInterval ) ;
                
                debug_print( "retry($retryCount/$retryCountMax)..." ) ;
                continue ;
            }
            debug_print( "ConfigureSandboxControllerNetworkSuccess: ip='$ip', mask='$mask', gateway='$gateway', dns='$dns'" ) ;
            
            echo "$ip $mask $gateway $dns" ;
            exit( 0 ) ;            
        }
    }
    
    catch( Exception $e ) {
        $msg = "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
        debug_print( "Exception caught: $msg" ) ;
        echo( $msg ) ;
        exit( 1 ) ;
    }
    
    return ;
}

